import pygame
from pygame.locals import *
from constants import *

class Pacman(object):
    def __init__(self, node):
        self.setPosition(node)
        self.direction = pygame.Vector2()
        self.direction_user = pygame.Vector2()
        self.speed = 100 * TILEWIDTH/16
        self.radius = 10
        self.color = YELLOW
    
    def setPosition(self, node):
        self.node = node
        self.position = node.position.copy()
        self.validDirections = self.setValidDirections()
        self.direction = pygame.Vector2()

    def setValidDirections(self):
        '''Given that the player is on a Node, set the valid directions to this nodes neighbors'''
        validDirections = []
        for neighbor in self.node.neighbors:
            direction = neighbor.position - self.node.position
            validDirections.append(direction.normalize())
        return validDirections
    
    def updateValidDirections(self):
        self.validDirections = [self.direction, -self.direction]
    
    def checkValidDirection(self, direction):
        '''Check that the direction we want to go is in a valid direction'''
        if direction in self.validDirections: return True
        return False

    def updateDirection(self, direction):
        self.direction_user = direction
        if self.checkValidDirection(direction):
            if self.direction == pygame.Vector2():
                self.direction = direction
                self.node = self.node.getNeighborByDirection(direction)
                self.updateValidDirections()
            else:  #reversing direction                
                if direction == -self.direction:
                    self.node = self.node.getNeighborByDirection(direction)
                    self.direction = direction

    def update(self, dt):	
        self.position += self.direction * self.speed * dt
        self.overshot()

    def overshot(self):
        '''Check if overshot node'''
        vec = self.node.position - self.position 
        if self.direction.dot(vec) < 0:  
            self.setPosition(self.node)

    def overshot(self):
        '''Check if overshot node'''
        vec = self.node.position - self.position
        if self.direction.dot(vec) < 0:  
            if self.continueNextNode():
                if self.node.getNeighborByDirection(self.direction_user) is None:
                    self.node = self.node.getNeighborByDirection(self.direction)
                else:
                    self.setPosition(self.node)
            else:
                self.setPosition(self.node)

    def continueNextNode(self):
        nextnode = self.node.getNeighborByDirection(self.direction)
        if nextnode is not None: return True
        return False
    
    def render(self, screen):
        pygame.draw.circle(screen, self.color, self.position, self.radius)